/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.ai.sensing;

import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.NearestVisibleLivingEntitySensor;
import net.minecraft.world.entity.ai.sensing.Sensor;

public class FishAttackablesSensor
extends NearestVisibleLivingEntitySensor {
    private final Predicate<LivingEntity> targetPredicate;

    public FishAttackablesSensor(Predicate<LivingEntity> targetPredicate) {
        this.targetPredicate = targetPredicate;
    }

    protected boolean isMatchingEntity(LivingEntity attacker, LivingEntity target) {
        return this.isClose(attacker, target) && target.isInWaterOrBubble() && this.isAttackableTarget(target) && Sensor.isEntityAttackable((LivingEntity)attacker, (LivingEntity)target);
    }

    protected MemoryModuleType<LivingEntity> getMemory() {
        return MemoryModuleType.NEAREST_ATTACKABLE;
    }

    private boolean isAttackableTarget(LivingEntity target) {
        return this.targetPredicate.test(target);
    }

    private boolean isClose(LivingEntity attacker, LivingEntity target) {
        return target.distanceToSqr((Entity)attacker) <= 64.0;
    }
}

